/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin;

import cds.aladin.Aladin;
import cds.aladin.Coord;
import cds.aladin.HealpixKey;
import cds.aladin.HealpixKeyRgb;
import cds.aladin.PlanBG;
import cds.aladin.ViewSimple;
import cds.allsky.TabRgb;
import cds.moc.SMoc;
import cds.tools.pixtools.CDSHealpix;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.Hashtable;

public class PlanBGRgb
extends PlanBG {
    public PlanBG red;
    public PlanBG green;
    public PlanBG blue;
    protected TabRgb tabRgb;

    protected PlanBGRgb(Aladin aladin, TabRgb tabRgb, String label, PlanBG red, PlanBG green, PlanBG blue, Coord co, double radius) {
        super(aladin);
        this.tabRgb = tabRgb;
        this.label = label;
        this.red = red;
        this.green = green;
        this.blue = blue;
        if (red != null) {
            red.addRecutListener(this);
            if (!red.isTruePixels()) {
                red.switchFormat();
            }
        }
        if (green != null) {
            green.addRecutListener(this);
            if (!green.isTruePixels()) {
                green.switchFormat();
            }
        }
        if (blue != null) {
            blue.addRecutListener(this);
            if (!blue.isTruePixels()) {
                blue.switchFormat();
            }
        }
        this.pixMode = 0;
        this.color = true;
        this.useCache = false;
        this.local = true;
        this.id = "ALADIN/P/RGB";
        this.co = co;
        this.coRadius = this.coRadius;
        this.suite();
    }

    @Override
    protected void suite() {
        PlanBG a = this.red != null ? this.red : (this.blue != null ? this.blue : this.green);
        this.minOrder = a.minOrder;
        this.maxOrder = a.maxOrder;
        this.flagNoTarget = a.flagNoTarget;
        this.objet = a.objet;
        this.body = a.objet;
        this.frameOrigin = a.frameOrigin;
        this.specificProj = a.specificProj;
        this.setNewProjD(a.projd.copy());
        this.tileOrder = a.tileOrder;
        this.setDefaultZoom(this.co, this.coRadius);
        this.suiteSpecific();
        this.launchLoading();
    }

    @Override
    protected void suiteSpecific() {
        this.selected = true;
        this.active = true;
        this.isOldPlan = false;
        this.pixList = new Hashtable(1000);
        this.RGBControl = new int[this.RGBCONTROL.length];
        for (int i = 0; i < this.RGBCONTROL.length; ++i) {
            this.RGBControl[i] = this.RGBCONTROL[i];
        }
        this.aladin.endMsg();
        this.resetStats();
    }

    protected void initTileParam(int width, int height) {
        this.naxis1 = this.width = width;
        this.naxis2 = this.height = height;
    }

    @Override
    protected boolean Free() {
        if (this.red != null) {
            this.red.addRecutListener(null);
        }
        if (this.green != null) {
            this.green.addRecutListener(null);
        }
        if (this.blue != null) {
            this.blue.addRecutListener(null);
        }
        return super.Free();
    }

    @Override
    protected boolean isLoading() {
        return false;
    }

    @Override
    public HealpixKey askForHealpix(int order, long npix) {
        HealpixKeyRgb pixAsk = new HealpixKeyRgb(this, order, npix);
        this.pixList.put(this.key(order, npix), pixAsk);
        return pixAsk;
    }

    @Override
    public boolean recut() {
        this.tabRgb.updateTables();
        this.updatePreview();
        return true;
    }

    public void updatePreview() {
        this.FreePixList();
        this.changeImgID();
        this.aladin.view.repaintAll();
    }

    @Override
    protected void tryWakeUp() {
        if (this.red != null) {
            this.red.tryWakeUp();
        }
        if (this.green != null) {
            this.green.tryWakeUp();
        }
        if (this.blue != null) {
            this.blue.tryWakeUp();
        }
    }

    @Override
    protected int getMinOrder() {
        return this.minOrder == -1 ? 0 : this.minOrder;
    }

    @Override
    protected synchronized void drawLosanges(Graphics g, ViewSimple v, boolean now, BufferedImage imgb) {
        this.drawLosangesNow(g, v, imgb);
    }

    @Override
    protected void drawLosangesNow(Graphics g, ViewSimple v, BufferedImage imgb) {
        int i;
        long[] pix;
        int order = Math.max(this.getMinOrder(), Math.min(this.maxOrder(v), this.maxOrder));
        if (v.isAllSky()) {
            pix = new long[12 * (int)CDSHealpix.pow2(order) * (int)CDSHealpix.pow2(order)];
            for (i = 0; i < pix.length; ++i) {
                pix[i] = i;
            }
        } else {
            pix = this.getPixList(v, this.getCooCentre(v), order);
        }
        for (i = 0; i < pix.length; ++i) {
            if (this.isOutMoc(order, pix[i]) || new HealpixKey(this, order, pix[i], 0).isOutView(v)) continue;
            HealpixKey k = this.getHealpix(order, pix[i], true);
            try {
                k.resetTimer();
                k.loadNow();
                k.draw(g, v);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void planReadyMoc() {
        try {
            SMoc m = new SMoc();
            if (this.red != null && this.red.moc != null) {
                m = m.union(this.red.moc);
            }
            if (this.green != null && this.green.moc != null) {
                m = m.union(this.green.moc);
            }
            if (this.blue != null && this.blue.moc != null) {
                m = m.union(this.blue.moc);
            }
            this.moc = new SMoc(m);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

